clear all;
close all;
clc;

%Caricamento delle matrici O/D e della mappatura
load 'IMQ2013_zonecampionarie';
fprintf('File MAT di riferimento:  IMQ2013_zonecampionarie.mat\n\n');
 
%Ottenimento dei dati di ingresso
zona1 = input('Inserire codice prima zona:     ');
zona2 = input('Inserire codice seconda zona:   ');
modo = input('Inserire il modo (Pr-privato, Pu-pubblico, T-totali): ');
per = input('Periodo (IG-intera giornata, OP-ora di punta): ');
if per == 'IG';
    scopo = input('Scopo (t-tutti, sr-tutti escluso ritorno): ');
else;
    scopo = 't';
end;

%Estrazione dei due flussi (andata/ritorno) in base all'input fornito
fprintf('\n- SPOSTAMENTI REGISTRATI TRA LE DUE ZONE -');
if modo=='T';
    nomeMATR1 = strcat('ResPIEmPu',per,scopo);
    nomeMATR2 = strcat('ResPIEmPr',per,scopo);
    if per=='IG',scopo=='sr';
        [SPOST1to2,SPOST2to1] = singval(ResPIEmPuIGsr,zona1,zona2,zoneA)+singval(ResPIEmPrIGsr,zona1,zona2,zoneA);
    end; if per=='IG',scopo=='t';
        [SPOST1to2,SPOST2to1] = singval(ResPIEmPuIGt,zona1,zona2,zoneA)+singval(ResPIEmPrIGt,zona1,zona2,zoneA);
    end; if per=='OP',scopo=='t';
        [SPOST1to2,SPOST2to1] = singval(ResPIEmPuOPt,zona1,zona2,zoneA)+singval(ResPIEmPrOPt,zona1,zona2,zoneA);
    end;
    fprintf('\nMatrici di riferimento:  ');fprintf(nomeMATR1);fprintf(' / ');fprintf(nomeMATR2);fprintf('\n');
else;
    nomeMATR = strcat('ResPIEm',modo,per,scopo);
    if modo=='Pu',per=='IG',scopo=='sr';
        [SPOST1to2,SPOST2to1] = singval(ResPIEmPuIGsr,zona1,zona2,zoneA);
    end; if modo=='Pu',per=='IG',scopo=='t';
        [SPOST1to2,SPOST2to1] = singval(ResPIEmPuIGt,zona1,zona2,zoneA);
    end; if modo=='Pu',per=='OP',scopo=='t';
        [SPOST1to2,SPOST2to1] = singval(ResPIEmPuOPt,zona1,zona2,zoneA);
    end; if modo=='Pr',per=='IG',scopo=='sr';
        [SPOST1to2,SPOST2to1] = singval(ResPIEmPrIGsr,zona1,zona2,zoneA);
    end; if modo=='Pr',per=='IG',scopo=='t';
        [SPOST1to2,SPOST2to1] = singval(ResPIEmPrIGt,zona1,zona2,zoneA);
    end; if modo=='Pr',per=='OP',scopo=='t';
        [SPOST1to2,SPOST2to1] = singval(ResPIEmPrOPt,zona1,zona2,zoneA);
    end;
    fprintf('\nMatrice di riferimento:  ');fprintf(nomeMATR);fprintf('\n');
end;
 
%Stampa a video dei risultati
fprintf(zona1);fprintf(' --> ');fprintf(zona2);fprintf('  =  ');fprintf('%.2f',SPOST1to2);fprintf('\n');
fprintf(zona2);fprintf(' --> ');fprintf(zona1);fprintf('  =  ');fprintf('%.2f',SPOST2to1);fprintf('\n');

%Definizione della funzione di estrazione dei valori
function [s1to2,s2to1] = singval(matrice,Z1,Z2,zone);
s1to2 = matrice(find(zone==Z1),find(zone==Z2));
s2to1 = matrice(find(zone==Z2),find(zone==Z1));
end